//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.Text;
using System.Net;
using System.Net.Sockets;

class Listener
{

	public static void Main()
	{
		Console.WriteLine("Gotowy do przetwarzania da...");
		ProcessRequests();	
	}

	public static Socket GetListenerSocket(string host, int port) 
	{
		Socket s = null;
		IPHostEntry iphe = Dns.Resolve(host);
		foreach(IPAddress ipa in iphe.AddressList) 
		{
			IPEndPoint lep = new IPEndPoint(ipa, port);
			Socket ts = new Socket(lep.AddressFamily,
				                   SocketType.Stream, 
				                   ProtocolType.Tcp);
			try 
			{
				ts.Bind(lep);
				ts.Listen(2);
				s = ts;
				break;
			} 
			catch (ArgumentNullException ae)
			{
				Console.WriteLine("Wyjtek ArgumentNullException: " + ae.ToString());
			}
			catch (SocketException se)
			{				
				Console.WriteLine("Wyjtek SocketException: " + se.ToString());
			}
			catch (Exception e) 
			{
				Console.WriteLine("Poczenie nie powiodo si: " + e.ToString());
			}
		}
		return s;
	}
	public static void ProcessRequests()
	{
		Socket server = GetListenerSocket(Dns.GetHostName(), 5000);
		Socket s = server.Accept();

		byte[] responseData = new byte[128];
		bool continueProcessing = true;

		while(continueProcessing)
		{	
			try
			{
				int bytesRead = s.Receive(responseData);
				// string message = Encoding.ASCII.GetString(responseData, 0, bytesRead);
				string message = Encoding.Unicode.GetString(responseData, 0, bytesRead);
				if(message == "quit")
				{
					continueProcessing = false;
					break;
				}
				else
				{
					Console.WriteLine("Otrzymana wiadomo to " + message);
				}
			}
			catch(Exception ex)
			{
				Console.WriteLine(ex.ToString());
			}
		}
		// Zamknicie poczenia klienta
		s.Close();
		// Zamknicie poczenia serwera
		server.Close();
	}
}
